
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MSG1070.C - Message 1070 Processing
// 
//
//   DESCRIPTION
//
//   Functions to decode, build, and display Zodiac 1170 messages.
//
//
//
////////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <share.h>
#include <string.h> 

#include "gentypes.h"
#include "gencons.h"
#include "ztypes.h"
#include "zcons.h"   
#include "util.h" 
#include "display.h"

////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac 1070 message from the ZMsgBuf.
//
void Dec1070(tMSGBUF *ZMsgBuf, tMSG1070 *Msg)
{                                            
}                                      
                                     
////////////////////////////////////////////////////////////////////////////////
//   
//   Build a Zodiac 1070 message in the ZMsgBuf. 
//
void Bld1070(tMSGBUF *ZMsgBuf, tMSG1070 *Msg)
{
}                                            

////////////////////////////////////////////////////////////////////////////////
//   
//   Display a Zodiac 1070 message from the ZMsgBuf.
//
void Show1070(tMSG1070 *Msg)
{
   char    Buf[80] = "";
   char    DRRun[8];        

   // dr validity flags  
   if(!(Msg->DataInvalid & 0x2))
     sprintf(Buf,"%c"      , 'V');
   else
     sprintf(Buf,"%c"      , 'v');

   ShowText(Buf,DRSR + 4, DRSC - 0);

   if(!(Msg->DataInvalid & 0x4))
     sprintf(Buf,"%c"      , 'H');
   else
     sprintf(Buf,"%c"      , 'h');

   ShowText(Buf,DRSR + 5, DRSC - 0);

   if(!(Msg->DataInvalid & 0x8))
     sprintf(Buf,"%c"      , 'B');
   else
     sprintf(Buf,"%c"      , 'b');
   
   ShowText(Buf,DRSR + 6, DRSC - 0);


   // DR Run Status:
   // bit 0/4 = 1: Gyro Zero-Speed Calibration Ran
   // bit 1/5 = 1: Gyro Bias and Scale Factor Calibration Ran
   // bit 2/6 = 1: Speed Calibration Ran
   // bit 3/7 = 1: DR Position Integration Ran
   // bit 4/8 = 1: DR System Updated the Navigation State
   //
   strcpy(DRRun, "        ");
   if((Msg->DataInvalid & 0x10))
     DRRun[0] = 'Z';
   else
     DRRun[0] = 'z';

   if((Msg->DataInvalid & 0x20))
     DRRun[1] = 'G';
   else
     DRRun[1] = 'g';

   if((Msg->DataInvalid & 0x40))
     DRRun[2] = 'S';
   else
     DRRun[2] = 's';

   if((Msg->DataInvalid & 0x80))
     DRRun[3] = 'P';
   else
     DRRun[3] = 'p';

   if((Msg->DataInvalid & 0x100))
     DRRun[4] = 'U';
   else
     DRRun[4] = 'u';

   if((Msg->DataInvalid & 0x200))
     DRRun[5] = 'D';
   else
     DRRun[5] = 'd';

   if((Msg->DataInvalid & 0x400))
     DRRun[6] = 'm';
   else
     DRRun[6] = 'M';

   if((Msg->DataInvalid & 0x800))
     DRRun[7] = 'n';
   else
     DRRun[7] = 'N';

   // output the data items   
   sprintf(Buf,"%8s",DRRun);		ShowText(Buf,DRSR + 3, DRSC + 8);

   sprintf(Buf,"%07.02f",(float)Msg->SpeedSF / 32768.0 * 100.0);		ShowText(Buf,DRSR + 4 ,DRSC+2);
   sprintf(Buf,"%06.02f",(float)Msg->SpeedSF_SD / 65536.0 * 100.0);		ShowText(Buf,DRSR + 4 ,DRSC+10);
   sprintf(Buf,"%07.02f",(float)Msg->HdgRateSF / 32768.0 * 100.0 );		ShowText(Buf,DRSR + 5 ,DRSC+2);
   sprintf(Buf,"%06.02f",(float)Msg->HdgRateSF_SD / 65536.0 * 100.0 );	ShowText(Buf,DRSR + 5 ,DRSC+10);
   sprintf(Buf,"%07.02f",(float)Msg->HdgRateBias / 32768.0 * 180.0 );	ShowText(Buf,DRSR + 6 ,DRSC+2);
   sprintf(Buf,"%06.02f",(float)Msg->HdgRateBias_SD / 65536.0 * 180.0);	ShowText(Buf,DRSR + 6 ,DRSC+10);
   sprintf(Buf,"%010.02f",(float)Msg->DRGPSTow / 100.0 );				ShowText(Buf,DRSR + 7 ,DRSC+6);
}                                                   
                                      
                                           
